
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		SHADOW_EPSILON 0.0025f
float4x4	g_shadowerTransform;
float		g_light_farPlane;
float		shader_misc_shadow_mapSize;
float		shader_misc_shadow_mapTexelSize;
float		g_shadow_offset;

////////////////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float3 normal		: NORMAL;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};


struct VS_OUTPUT_HIGH
{
	float4 position		: POSITION;
	float4 posTex		: TEXCOORD0;
	float depth			: TEXCOORD1;
	
	float3 normal		: TEXCOORD2;
	float2 tex0			: TEXCOORD3;
	float3 tex1			: TEXCOORD4;
	float4 diffuse		: COLOR0;
	float4 specular		: COLOR1;
};

////////////////////////////////////////////////////////////////////
// functions

VS_OUTPUT_HIGH vs_lighting_high_glow( VS_INPUT input )
{
	VS_OUTPUT_HIGH output = (VS_OUTPUT_HIGH) 0;

	output.position = mul(input.position, shader_transform_world);
	output.normal = normalize(mul(input.normal, (float3x3)shader_transform_world));
		
	float3 vCamera = normalize(output.position-shader_camera_eyePosition);
	float3 vHalfway = normalize(-shader_light_direction - vCamera);
	
	output.specular = shader_material_specular.r * shader_light_specular.r * saturate(pow(dot( output.normal, vHalfway ), (1.0 / shader_material_eccentricity)*5));
	output.diffuse = float4(saturate(dot( output.normal, -shader_light_direction )) * shader_light_diffuse.rgb,shader_material_transparency + output.specular.r);
	
	output.posTex = mul( output.position, shader_light_viewProj );
	output.position = mul(output.position, shader_transform_viewProj);
	output.depth = saturate(output.posTex.z);

	
  	output.tex0 = input.tex0;
	output.tex1 = reflect( vCamera,output.normal );

	return output;
}

///////////////////////////////////////////////////////////////

sampler sample_colour_0 = sampler_state 
{ 
	Texture = (shader_texture_0);  
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
	MipFilter = LINEAR;  
};

sampler sample_colour_glow = sampler_state 
{ 
	Texture = (shader_texture_2);  
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
	MipFilter = LINEAR;  
};

sampler sample_colour_shadow = sampler_state 
{ 
	Texture = (shader_texture_shadowmap); 
	AddressU = Clamp; 
	AddressV = Clamp; 
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
};

sampler sample_colour_cube = sampler_state 
{ 
	Texture = (shader_texture_cubemap);  
	MinFilter = LINEAR; 
	MagFilter = LINEAR;  
};

///////////////////////////////////////////////////////////////

float4 ps_lighting_high_glow( VS_OUTPUT_HIGH input ) : COLOR0
{
	float2 projTexCoords;
	projTexCoords.x = input.posTex.x / 2.0f + 0.5f;
	projTexCoords.y = -input.posTex.y / 2.0f + 0.5f;

	float shadowTerm = ((tex2D( sample_colour_shadow, projTexCoords ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, 0.0f ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( 0.0f, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, -shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( -shader_misc_shadow_mapTexelSize, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)
		 + (tex2D( sample_colour_shadow, projTexCoords + float2( shader_misc_shadow_mapTexelSize, shader_misc_shadow_mapTexelSize ) ).x <= input.depth - SHADOW_EPSILON ? shader_light_ambient.r : 1.0f)) / 9.0f;

	float4 textureColour = lerp( tex2D(sample_colour_0, input.tex0), float4(texCUBE(sample_colour_cube, input.tex1).rgb,1), shader_material_reflectivity);
	
	float4 finalColour = shader_geometry_colour * float4((shader_light_ambient.rgb + input.diffuse.rgb * shadowTerm) * textureColour.rgb + input.specular, input.diffuse.a * (textureColour.a + input.specular.r ));

	finalColour.rgb = finalColour.rgb + tex2D(sample_colour_glow, input.tex0).rgb;

	return finalColour;
}

////////////////////////////////////////////////////////////

technique tech_lighting_high_glow_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_high_glow();	
		PixelShader = compile ps_2_0 ps_lighting_high_glow();	
	}
}

technique tech_lighting_high_glow_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_lighting_high_glow();	
	}
}